<?php
// Bật hiển thị lỗi để dễ dàng gỡ lỗi nếu có vấn đề khác
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: text/html; charset=utf-8');
require_once __DIR__ . '/../../core/init.php';

$transfer_id = intval($_GET['id'] ?? 0);
if ($transfer_id <= 0) {
    die('ID phiếu chuyển kho không hợp lệ.');
}

// === BẮT ĐẦU SỬA LỖI SQL ===
// Lấy tên người nhận từ cột user_upd (người xác nhận) thay vì receiver_id
$sql = "SELECT
            t.transfer_code,
            t.created as transfer_date,
            t.updated as received_date,
            t.notes,
            t.detail_transfer,
            s_from.store_name as from_store_name,
            s_to.store_name as to_store_name,
            u_creator.display_name as creator_name,
            u_confirmer.display_name as receiver_name
        FROM cms_transfer t
        LEFT JOIN cms_stores s_from ON t.from_store = s_from.id
        LEFT JOIN cms_stores s_to ON t.to_store = s_to.id
        LEFT JOIN cms_users u_creator ON t.user_init = u_creator.id
        LEFT JOIN cms_users u_confirmer ON t.user_upd = u_confirmer.id
        WHERE t.id = ?";
// === KẾT THÚC SỬA LỖI SQL ===

$stmt = $conn->prepare($sql);
if ($stmt === false) { die('Lỗi chuẩn bị câu lệnh SQL: ' . $conn->error); }

$stmt->bind_param('i', $transfer_id);
$stmt->execute();
$transfer = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$transfer) { die('Không tìm thấy phiếu chuyển kho với ID này.'); }

$products_from_json = json_decode($transfer['detail_transfer'], true);
if (!is_array($products_from_json)) { $products_from_json = []; }

$product_ids = [];
if (!empty($products_from_json)) {
    $product_ids = array_column($products_from_json, 'id');
    $product_ids = array_filter(array_unique($product_ids));
}

$products_info_map = [];
if (!empty($product_ids)) {
    $placeholders = implode(',', array_fill(0, count($product_ids), '?'));
    $types = str_repeat('i', count($product_ids));
    $sql_products = "SELECT id, prd_name FROM cms_products WHERE id IN ($placeholders)";
    $stmt_products = $conn->prepare($sql_products);
    if($stmt_products){
        $stmt_products->bind_param($types, ...$product_ids);
        $stmt_products->execute();
        $result = $stmt_products->get_result();
        while($row = $result->fetch_assoc()) {
            $products_info_map[$row['id']] = $row;
        }
        $stmt_products->close();
    }
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Phiếu Chuyển Kho - <?php echo htmlspecialchars($transfer['transfer_code']); ?></title>
    <style>
        body { font-family: 'Times New Roman', Times, serif; font-size: 13pt; margin: 0; background-color: #f0f2f5; }
        .print-container { width: 210mm; min-height: 297mm; margin: 20px auto; background: white; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        .page { padding: 2cm; }
        .main-title { font-size: 20pt; font-weight: bold; text-align: center; margin-bottom: 25px; text-transform: uppercase; }
        .info-table { width: 100%; border-collapse: collapse; margin-top: 15px; line-height: 1.8; }
        .info-table td { padding: 5px; vertical-align: top; }
        .products-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .products-table th, .products-table td { border: 1px solid #333; padding: 8px; text-align: center; vertical-align: middle; }
        .products-table th { font-weight: bold; }
        .products-table .text-left { text-align: left; }
        .text-bold { font-weight: bold; }
        .footer-signatures { display: flex; justify-content: space-around; text-align: center; margin-top: 60px; page-break-inside: avoid; }
        .footer-signatures div { font-weight: bold; }
        .footer-signatures span { font-style: italic; font-weight: normal; font-size: 11pt; }
        .no-print { position: fixed; top: 10px; right: 10px; z-index: 1000; }
        @media print {
            body { background-color: white; }
            .no-print, .print-container { margin: 0; box-shadow: none; }
            .page { padding: 1.5cm; }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()" style="padding: 10px 15px; font-size: 16px; cursor: pointer;">In Phiếu</button>
    </div>
    <div class="print-container">
        <div class="page">
            <?php require __DIR__ . '/../../templates/print_header_template.php'; ?>
            
            <div class="main-title">PHIẾU CHUYỂN KHO</div>
            <div style="text-align: center; font-style: italic;">
                Ngày <?php echo date('d', strtotime($transfer['transfer_date'])); ?> 
                tháng <?php echo date('m', strtotime($transfer['transfer_date'])); ?> 
                năm <?php echo date('Y', strtotime($transfer['transfer_date'])); ?>
            </div>
            
            <table class="info-table">
                <tr>
                    <td width="15%" class="text-bold">Mã phiếu:</td>
                    <td><?php echo htmlspecialchars($transfer['transfer_code']); ?></td>
                </tr>
                <tr>
                    <td class="text-bold">Người chuyển:</td>
                    <td><?php echo htmlspecialchars($transfer['creator_name'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td class="text-bold">Người nhận:</td>
                    <td><?php echo htmlspecialchars($transfer['receiver_name'] ?? 'Chưa xác nhận'); ?></td>
                </tr>
                <tr>
                    <td class="text-bold">Từ kho:</td>
                    <td><?php echo htmlspecialchars($transfer['from_store_name'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td class="text-bold">Đến kho:</td>
                    <td><?php echo htmlspecialchars($transfer['to_store_name'] ?? 'N/A'); ?></td>
                </tr>
                <?php if (!empty($transfer['notes'])): ?>
                <tr>
                    <td class="text-bold">Ghi chú:</td>
                    <td><?php echo nl2br(htmlspecialchars($transfer['notes'])); ?></td>
                </tr>
                <?php endif; ?>
            </table>
            
            <table class="products-table">
                <thead>
                    <tr>
                        <th style="width:10%">STT</th>
                        <th class="text-left">Tên sản phẩm</th>
                        <th style="width:20%">Số lượng</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $stt = 1;
                    $total_quantity = 0;
                    foreach($products_from_json as $item): 
                        $product_id = intval($item['id'] ?? 0);
                        $quantity = $item['quantity'] ?? 0;
                        $total_quantity += $quantity;
                        $product_name = isset($products_info_map[$product_id]) ? $products_info_map[$product_id]['prd_name'] : ($item['name'] ?? 'Sản phẩm không xác định');
                    ?>
                    <tr>
                        <td><?php echo $stt++; ?></td>
                        <td class="text-left"><?php echo htmlspecialchars($product_name); ?></td>
                        <td class="text-bold"><?php echo number_format($quantity); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="2" style="text-align:right; padding-right: 8px;">Tổng số lượng</th>
                        <th class="text-bold"><?php echo number_format($total_quantity); ?></th>
                    </tr>
                </tfoot>
            </table>

            <div class="footer-signatures">
                <div>Người lập phiếu<br><span>(Ký, ghi rõ họ tên)</span></div>
                <div>Người giao hàng<br><span>(Ký, ghi rõ họ tên)</span></div>
                <div>Thủ kho (Xuất)<br><span>(Ký, ghi rõ họ tên)</span></div>
                <div>Thủ kho (Nhập)<br><span>(Ký, ghi rõ họ tên)</span></div>
            </div>
        </div>
    </div>
</body>
</html>