<?php
header('Content-Type: application/json');
// Adjust the path if your database.php is in a different location
require_once __DIR__ . '/../../config/database.php'; 

$response = ["status" => "success", "message" => "Status updated successfully."];
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['id']) || !isset($input['status'])) {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Missing required fields."]);
    exit;
}

$id = $input['id'];
$status = $input['status'];

try {
    $stmt = $conn->prepare("UPDATE service_appointments SET status = ? WHERE id = ?");
    if ($stmt === false) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param("si", $status, $id);
    $stmt->execute();
    $stmt->close();
} catch (Exception $e) {
    http_response_code(500);
    $response = ["status" => "error", "message" => $e->getMessage()];
}

echo json_encode($response);
$conn->close();
?>