<?php
require_once __DIR__ . '/../../core/database.php';
$id = (int)($_GET['id'] ?? 0);
$stmt = $conn->prepare("SELECT * FROM service_appointments WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$appointment = $stmt->get_result()->fetch_assoc();
if (!$appointment) die('Không tìm thấy phiếu hẹn.');
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Phiếu hẹn sửa chữa</title>
    <style>
        body { font-family: 'Arial', sans-serif; margin: 0; padding: 20px; font-size: 14px; }
        .receipt { width: 300px; margin: auto; padding: 15px; border: 1px solid #ccc; }
        h2 { text-align: center; margin-top: 0; }
        .info p { margin: 5px 0; }
        .info strong { display: inline-block; min-width: 100px; }
        hr { border: none; border-top: 1px dashed #000; margin: 15px 0; }
        .footer { text-align: center; margin-top: 20px; font-style: italic; }
        @media print { body { padding: 0; } .receipt { width: 100%; border: none; } }
    </style>
</head>
<body onload="window.print()">
    <div class="receipt">
        <h2>PHIẾU HẸN SỬA CHỮA</h2>
        <p style="text-align:center;"><?php echo date('d/m/Y H:i'); ?></p>
        <hr>
        <div class="info">
            <p><strong>Khách hàng:</strong> <?php echo htmlspecialchars($appointment['customer_name']); ?></p>
            <p><strong>Điện thoại:</strong> <?php echo htmlspecialchars($appointment['customer_phone']); ?></p>
            <p><strong>Hẹn lấy lúc:</strong> <strong><?php echo date('H:i - d/m/Y', strtotime($appointment['appointment_datetime'])); ?></strong></p>
            <p><strong>Ghi chú:</strong></p>
            <div style="padding-left:10px; min-height: 50px;"><?php echo nl2br(htmlspecialchars($appointment['notes'])); ?></div>
        </div>
        <hr>
        <div class="footer">
            Cảm ơn quý khách!
        </div>
    </div>
</body>
</html>