<?php
// Bật tất cả lỗi để dễ dàng kiểm tra nếu có vấn đề
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../core/init.php';

// 1. LẤY VÀ XÁC THỰC CÁC THAM SỐ LỌC
$user_id_from_get = $_GET['user_id'] ?? '';
$from_date = $_GET['from'] ?? '';
$to_date = $_GET['to'] ?? '';

// Kiểm tra user_id hợp lệ (chấp nhận cả giá trị 0)
if ($user_id_from_get === '' || !is_numeric($user_id_from_get)) {
    exit("Lỗi: Vui lòng chọn một nhân viên hợp lệ để xuất báo cáo.");
}
$user_id = intval($user_id_from_get);

// 2. LẤY TÊN NHÂN VIÊN VÀ TẠO TÊN FILE
$employee_name_stmt = $conn->prepare("SELECT username FROM cms_users WHERE id = ?");
$employee_name_stmt->bind_param("i", $user_id);
$employee_name_stmt->execute();
$employee_name = $employee_name_stmt->get_result()->fetch_assoc()['username'] ?? 'unknown_user';
$employee_name_stmt->close();

$filename = "bao-cao-doanh-so_" . $employee_name . "_tu_" . $from_date . "_den_" . $to_date . ".xls";

// 3. GỬI HEADER ĐỂ TRÌNH DUYỆT TẢI FILE
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=\"$filename\"");
header("Pragma: no-cache");
header("Expires: 0");

// =================================================================
// PHẦN 4: SỬA LỖI LOGIC XÂY DỰNG CÂU TRUY VẤN
// =================================================================
$whereClauses = ["o.deleted = 0", "o.order_status > 0"];
$params = [];
$types = '';

// Thêm điều kiện ngày tháng vào mảng params và types TRƯỚC
if (!empty($from_date) && !empty($to_date)) {
    $whereClauses[] = "o.sell_date BETWEEN ? AND ?";
    $params[] = $from_date . ' 00:00:00';
    $params[] = $to_date . ' 23:59:59';
    $types .= 'ss';
}

// Thêm điều kiện nhân viên vào mảng params và types SAU
// Thứ tự này phải khớp với thứ tự các dấu '?' trong mệnh đề WHERE
$whereClauses[] = "o.user_init = ?";
$params[] = $user_id;
$types .= 'i';

$whereSql = " WHERE " . implode(' AND ', $whereClauses);

// SỬA LỖI CÚ PHÁP SQL: Đã viết lại sạch sẽ, không còn ký tự đặc biệt
$sql_report = "SELECT
                    o.output_code,
                    o.sell_date,
                    c.customer_name,
                    o.total_money,
                    o.total_origin_price,
                    (o.total_money - o.total_origin_price) as profit
                FROM cms_orders o
                LEFT JOIN cms_customers c ON o.customer_id = c.ID
                {$whereSql}
                ORDER BY o.sell_date ASC";

$stmt_report = $conn->prepare($sql_report);

if ($stmt_report === false) {
    exit("Lỗi chuẩn bị câu lệnh SQL: " . $conn->error);
}

if (!empty($types)) {
    $stmt_report->bind_param($types, ...$params);
}

$stmt_report->execute();
$report_data = $stmt_report->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_report->close();
$conn->close();

// =================================================================
// PHẦN 5: XUẤT DỮ LIỆU RA FILE EXCEL
// =================================================================
echo '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40">';
echo '<head><meta http-equiv="Content-type" content="text/html;charset=utf-8" /></head>';
echo '<body>';
echo '<table border="1">';
echo '<thead>';
echo '<tr><th colspan="6" style="font-size: 16px; font-weight: bold; text-align: center;">BÁO CÁO KINH DOANH CHI TIẾT - NHÂN VIÊN: ' . htmlspecialchars(strtoupper($employee_name)) . '</th></tr>';
echo '<tr><th colspan="6" style="text-align: center;">TỪ NGÀY: ' . htmlspecialchars(date('d/m/Y', strtotime($from_date))) . ' ĐẾN NGÀY: ' . htmlspecialchars(date('d/m/Y', strtotime($to_date))) . '</th></tr>';
echo '<tr><th>STT</th><th>Mã đơn hàng</th><th>Ngày bán</th><th>Khách hàng</th><th>Doanh số</th><th>Lợi nhuận</th></tr>';
echo '</thead>';
echo '<tbody>';

$stt = 1;
$total_revenue_sum = 0;
$total_profit_sum = 0;

if (empty($report_data)) {
    echo '<tr><td colspan="6" style="text-align:center;">Không có dữ liệu</td></tr>';
} else {
    foreach($report_data as $row) {
        $total_revenue_sum += $row['total_money'];
        $total_profit_sum += $row['profit'];
        echo '<tr>';
        echo '<td>' . $stt++ . '</td>';
        echo '<td>' . htmlspecialchars($row['output_code']) . '</td>';
        echo '<td>' . date('d/m/Y H:i', strtotime($row['sell_date'])) . '</td>';
        echo '<td>' . htmlspecialchars($row['customer_name'] ?? 'Khách lẻ') . '</td>';
        echo '<td style="text-align:right;">' . number_format($row['total_money']) . '</td>';
        echo '<td style="text-align:right;">' . number_format($row['profit']) . '</td>';
        echo '</tr>';
    }
}

// Dòng tổng kết
echo '<tr>';
echo '<td colspan="4" style="text-align:right; font-weight:bold;">TỔNG CỘNG</td>';
echo '<td style="text-align:right; font-weight:bold;">' . number_format($total_revenue_sum) . '</td>';
echo '<td style="text-align:right; font-weight:bold;">' . number_format($total_profit_sum) . '</td>';
echo '</tr>';

echo '</tbody>';
echo '</table>';
echo '</body></html>';
?>