<?php
require_once __DIR__ . '/../../core/init.php';
require_once __DIR__ . '/../../templates/header.php';
require_once __DIR__ . '/../../includes/receipt_helpers.php'; 
// Lấy danh sách hình thức thu để đưa vào bộ lọc và form


?>

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Danh sách phiếu thu</h1>
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Phiếu thu</h6>
            <button class="btn btn-primary btn-sm" id="btn-add-receipt"><i class="fas fa-plus"></i> Tạo mới</button>
        </div>
        <div class="card-body">
            <form id="filter-form" class="row g-3 mb-3">
                <div class="col-md-3">
                    <input type="text" class="form-control" name="search_term" id="search_term" placeholder="Nhập mã phiếu để tìm">
                </div>
                <div class="col-md-3">
                    <select name="type_id" id="type_id_filter" class="form-control">
                        <option value="">Tất cả hình thức</option>
                        <?php foreach($receipt_types as $id => $name): ?>
                            <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($name); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <input type="text" name="start_date" id="start_date" class="form-control" placeholder="Từ ngày">
                </div>
                <div class="col-md-2">
                    <input type="text" name="end_date" id="end_date" class="form-control" placeholder="Đến ngày">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i> Tìm kiếm</button>
                </div>
            </form>

            <table id="receipts-table" class="table table-bordered" width="100%">
                <thead>
                    <tr>
                        <th>Mã phiếu</th>
                        <th>Chứng từ</th>
                        <th>Kho thu</th>
                        <th>Ngày thu</th>
                        <th>Người thu</th>
                        <th>Ghi chú</th>
                        <th>Hình thức thu</th>
                        <th>Tổng tiền</th>
                        <th>Hành động</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="7" class="text-right">Tổng cộng:</th>
                        <th id="total-sum" class="text-right"></th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="receipt-modal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="receipt-form" enctype="multipart/form-data">
                <input type="hidden" name="action" value="save_receipt">
                <input type="hidden" name="id" id="receipt-id">
                <input type="hidden" name="current_image" id="current-image">

                <div class="modal-header">
                    <h5 class="modal-title" id="modal-title">Tạo phiếu thu</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="notes">Ghi chú</label>
                        <input type="text" class="form-control" id="notes" name="notes" placeholder="Nhập ghi chú">
                    </div>
                    <div class="row">
                        <div class="col-md-6 form-group">
                             <label for="type_id">Hình thức thu</label>
                            <select name="type_id" id="type_id_form" class="form-control" required>
                                <option value="">-- Chọn hình thức --</option>
                                <?php foreach($receipt_types as $id => $name): ?>
                                    <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($name); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                         <div class="col-md-6 form-group">
                            <label for="total_money">Số tiền thu</label>
                            <input type="number" class="form-control" id="total_money" name="total_money" required>
                        </div>
                    </div>
                     <div class="form-group">
                        <label for="customer_id">Khách hàng (nếu có)</label>
                        <select id="customer_id" name="customer_id" class="form-control"></select>
                    </div>
                    <div class="form-group">
                        <label for="receipt_date">Ngày thu</label>
                        <input type="datetime-local" class="form-control" id="receipt_date" name="receipt_date" required>
                    </div>
                    <div class="form-group">
                        <label>Upload hình ảnh chứng từ</label>
                        <input type="file" name="receipt_image" class="form-control-file">
                        <div id="image-preview" class="mt-2"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Bỏ qua</button>
                    <button type="submit" class="btn btn-primary">Lưu</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css" rel="stylesheet"/>

<script>
$(document).ready(function() {
    // Khởi tạo datepicker
    $('#start_date, #end_date').datepicker({
        format: 'yyyy-mm-dd',
        autoclose: true,
        todayHighlight: true
    });
    
    // Khởi tạo Select2 cho khách hàng
    $('#customer_id').select2({
        placeholder: 'Tìm kiếm khách hàng',
        ajax: {
            url: '/quanlybanhang/ajax/customers_ajax.php', // Dùng lại ajax của khách hàng
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    action: 'get_customers', // Giả sử có action này để tìm kiếm
                    search_term: params.term 
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data.data, function(item) {
                        return { id: item.ID, text: item.customer_name + ' (' + item.customer_code + ')' }
                    })
                };
            }
        }
    });

    // Khởi tạo DataTables
    var table = $('#receipts-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '/quanlybanhang/ajax/receipts_ajax.php',
            type: 'POST',
            data: function(d) {
                d.action = 'get_receipts';
                d.search_term = $('#search_term').val();
                d.type_id = $('#type_id_filter').val();
                d.start_date = $('#start_date').val();
                d.end_date = $('#end_date').val();
            }
        },
        columns: [
            { data: 'receipt_code' },
            { data: 'receipt_image', render: function(data) {
                return data ? `<a href="/quanlybanhang/${data}" target="_blank"><img src="/quanlybanhang/${data}" width="50" /></a>` : 'Không có';
            }},
            { data: 'store_name' },
            { data: 'receipt_date' },
            { data: 'user_name' },
            { data: 'notes' },
            { data: 'type_name' },
            { data: 'total_money', className: 'text-right', render: $.fn.dataTable.render.number('.', ',', 0, '', ' đ') },
            { data: 'ID', orderable: false, render: function(data) {
                return `<button class="btn btn-warning btn-sm btn-edit" data-id="${data}"><i class="fas fa-edit"></i></button>
                        <button class="btn btn-danger btn-sm btn-delete" data-id="${data}"><i class="fas fa-trash"></i></button>`;
            }}
        ],
        language: { "url": "/quanlybanhang/assets/libs/datatables/vietnamese.json" },
        footerCallback: function (row, data, start, end, display) {
            var api = this.api();
            var totalSum = api.ajax.json().totalSum || 0;
            $(api.column(7).footer()).html($.fn.dataTable.render.number('.', ',', 0, '', ' đ').display(totalSum));
        }
    });

    // Lọc form
    $('#filter-form').on('submit', function(e) {
        e.preventDefault();
        table.ajax.reload();
    });

    // Mở modal thêm mới
    $('#btn-add-receipt').on('click', function() {
        $('#receipt-form')[0].reset();
        $('#receipt-id').val('');
        $('#modal-title').text('Tạo phiếu thu');
        $('#image-preview').html('');
        $('#customer_id').val(null).trigger('change');
        $('#receipt-modal').modal('show');
    });

    // Lưu form (thêm/sửa)
    $('#receipt-form').on('submit', function(e) {
        e.preventDefault();
        var formData = new FormData(this);
        $.ajax({
            url: '/quanlybanhang/ajax/receipts_ajax.php',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            dataType: 'json',
            success: function(response) {
                alert(response.message);
                if (response.status === 'success') {
                    $('#receipt-modal').modal('hide');
                    table.ajax.reload();
                }
            }
        });
    });

    // Mở modal sửa
    $('#receipts-table').on('click', '.btn-edit', function() {
        var id = $(this).data('id');
        $.getJSON('/quanlybanhang/ajax/receipts_ajax.php', { action: 'get_receipt_details', id: id }, function(response) {
            if (response.status === 'success' && response.data) {
                var d = response.data;
                $('#receipt-id').val(d.ID);
                $('#notes').val(d.notes);
                $('#type_id_form').val(d.type_id);
                $('#total_money').val(d.total_money);
                $('#receipt_date').val(d.receipt_date.replace(' ', 'T'));
                $('#current-image').val(d.receipt_image);
                $('#image-preview').html(d.receipt_image ? `<img src="/quanlybanhang/${d.receipt_image}" width="100" />` : '');
                
                // Cần thêm logic để hiển thị khách hàng đã chọn nếu có
                
                $('#modal-title').text('Sửa phiếu thu');
                $('#receipt-modal').modal('show');
            }
        });
    });
    
    // Xóa phiếu thu
    $('#receipts-table').on('click', '.btn-delete', function() {
        var id = $(this).data('id');
        if (confirm('Bạn có chắc muốn xóa phiếu thu này?')) {
            $.post('/quanlybanhang/ajax/receipts_ajax.php', { action: 'delete_receipt', id: id }, function(response) {
                alert(response.message);
                if(response.status === 'success') table.ajax.reload();
            }, 'json');
        }
    });
});
</script>