<?php
// ===================================================================
// BƯỚC 1: KHỞI TẠO VÀ KIỂM TRA QUYỀN TRUY CẬP
// ===================================================================
require_once __DIR__ . '/../../core/init.php';

// Kiểm tra xem người dùng có quyền xem trang đơn hàng không
if (!has_permission('orders')) {
    // Nếu không có quyền, hiển thị thông báo lỗi và dừng lại.
    // Bạn có thể chuyển hướng về trang chủ hoặc trang báo lỗi nếu muốn.
    // header('Location: /quanlybanhang/index.php');
    include __DIR__ . '/../../templates/header.php'; // Nạp header để có giao diện
    echo '<div class="container mt-5"><div class="alert alert-danger">Bạn không có quyền truy cập chức năng này.</div></div>';
    include __DIR__ . '/../../templates/footer.php'; // Nạp footer
    exit();
}


// ===================================================================
// BƯỚC 2: TRUY VẤN CSDL ĐỂ LẤY DANH SÁCH ĐƠN HÀNG
// ===================================================================

// Chuẩn bị câu SQL cơ bản
$sql = "SELECT
            o.ID,
            o.output_code,
            o.sell_date,
            o.total_money,
            o.customer_pay,
            o.detail_order,
            u.display_name AS seller_name
        FROM
            cms_orders o
        LEFT JOIN
            cms_users u ON o.user_id = u.ID
        WHERE
            o.deleted = 0";

// Dùng hàm has_permission() để kiểm tra vai trò người dùng
// Nếu không có quyền 'dashboard' (tức là không phải quản lý), thì chỉ xem được đơn hàng của mình
if (!has_permission('dashboard')) {
    $sql .= " AND o.user_id = ?";
}

$sql .= " ORDER BY o.ID DESC"; // Sắp xếp theo ID giảm dần để đơn mới nhất lên đầu

$stmt = $conn->prepare($sql);

if (!has_permission('dashboard')) {
    // Nếu là nhân viên, gán ID user từ session vào câu lệnh
    $stmt->bind_param("i", $_SESSION['user_id']);
}

$stmt->execute();
$result = $stmt->get_result();
$orders = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $orders[] = $row;
    }
}
$stmt->close();
// $conn->close(); // Không cần đóng kết nối ở đây vì footer.php có thể sẽ dùng đến

// Hàm tiện ích để format số, bạn có thể chuyển vào file helpers.php nếu muốn
function format_currency($number) {
    return number_format($number, 0, ',', '.') . ' đ';
}

// Nạp header của trang
include __DIR__ . '/../../templates/header.php';
?>

<style>
    body {
        background-color: #f0f2f5;
    }
    .order-card {
        border: none;
        border-radius: 0.75rem;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        margin-bottom: 1rem;
        transition: all 0.3s ease-in-out;
    }
    .order-card-header {
        background-color: #fff;
        border-bottom: 1px solid #f0f0f0;
        padding: 1rem;
        cursor: pointer;
        border-top-left-radius: 0.75rem;
        border-top-right-radius: 0.75rem;
    }
    .order-code {
        font-weight: 700;
        color: #0d6efd;
    }
    .order-date {
        font-size: 0.85rem;
        color: #6c757d;
    }
    .order-total {
        font-size: 1.1rem;
        font-weight: 700;
        color: #dc3545;
    }
    .expand-icon {
        font-size: 1.2rem;
        transition: transform 0.3s ease;
    }
    .order-card-header[aria-expanded="true"] .expand-icon {
        transform: rotate(45deg);
        color: #dc3545;
    }
    .order-details-body {
        background-color: #fafafa;
        padding: 0;
        border-bottom-left-radius: 0.75rem;
        border-bottom-right-radius: 0.75rem;
    }
    .details-table {
        margin-bottom: 0;
    }
    .details-table th {
        font-size: 0.8rem;
        text-transform: uppercase;
        background-color: #f1f1f1;
    }
    .details-table td {
        vertical-align: middle;
    }
    .status-badge {
        font-size: 0.8rem;
    }
</style>
<div class="container py-4">
    <h3 class="text-center mb-4 fw-bold">
        <i class="fas fa-receipt me-2"></i>
        Danh Sách Đơn Hàng
    </h3>

    <div class="accordion" id="ordersAccordion">
        <?php if (empty($orders)): ?>
            <div class="alert alert-info text-center">
                <i class="fas fa-info-circle me-2"></i>
                Không tìm thấy đơn hàng nào.
            </div>
        <?php else: ?>
            <?php foreach ($orders as $order): ?>
                <?php
                    // Tính toán trạng thái đơn hàng
                    $debt = $order['total_money'] - $order['customer_pay'];
                    $status_class = ($debt > 0) ? 'bg-warning text-dark' : 'bg-success';
                    $status_text = ($debt > 0) ? 'Còn nợ' : 'Hoàn tất';

                    // Decode chi tiết sản phẩm từ chuỗi JSON trong cột 'detail_order'
                    $products = json_decode($order['detail_order'], true);
                ?>
                <div class="card order-card">
                    <div class="card-header order-card-header" id="heading-<?php echo $order['ID']; ?>" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo $order['ID']; ?>" aria-expanded="false" aria-controls="collapse-<?php echo $order['ID']; ?>">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <div class="order-code"><?php echo htmlspecialchars($order['output_code']); ?></div>
                                <div class="order-date">
                                    <i class="far fa-calendar-alt me-1"></i>
                                    <?php echo date("d/m/Y H:i", strtotime($order['sell_date'])); ?>
                                </div>
                            </div>
                            <div class="text-end">
                                <div class="order-total"><?php echo format_currency($order['total_money']); ?></div>
                                <span class="badge rounded-pill <?php echo $status_class; ?> status-badge"><?php echo $status_text; ?></span>
                            </div>
                            <i class="fas fa-plus expand-icon"></i>
                        </div>
                    </div>

                    <div id="collapse-<?php echo $order['ID']; ?>" class="collapse" aria-labelledby="heading-<?php echo $order['ID']; ?>" data-bs-parent="#ordersAccordion">
                        <div class="card-body order-details-body">
                            <table class="table table-sm table-striped details-table">
                                <thead class="table-light">
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Tên sản phẩm</th>
                                        <th scope="col" class="text-center">SL</th>
                                        <th scope="col" class="text-end">ĐG</th>
                                        <th scope="col" class="text-end">TT</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (is_array($products) && !empty($products)): ?>
                                        <?php $stt = 1; foreach ($products as $product): ?>
                                            <tr>
                                                <td><?php echo $stt++; ?></td>
                                                <td><?php echo htmlspecialchars($product['name']); ?></td>
                                                <td class="text-center"><?php echo htmlspecialchars($product['quantity']); ?></td>
                                                <td class="text-end"><?php echo format_currency($product['price']); ?></td>
                                                <td class="text-end fw-bold"><?php echo format_currency($product['quantity'] * $product['price']); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="5" class="text-center text-muted fst-italic py-3">Không có chi tiết sản phẩm.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<?php
// Nạp footer của trang
include __DIR__ . '/../../templates/footer.php';
?>

<script>
document.addEventListener('DOMContentLoaded', function () {
    var accordion = document.getElementById('ordersAccordion');
    if(accordion){
        // Lắng nghe sự kiện khi một mục được mở
        accordion.addEventListener('show.bs.collapse', function (event) {
            let header = event.target.previousElementSibling;
            let icon = header.querySelector('.expand-icon');
            if (icon) {
                icon.classList.remove('fa-plus');
                icon.classList.add('fa-minus');
            }
        });

        // Lắng nghe sự kiện khi một mục được đóng
        accordion.addEventListener('hide.bs.collapse', function (event) {
            let header = event.target.previousElementSibling;
            let icon = header.querySelector('.expand-icon');
            if (icon) {
                icon.classList.remove('fa-minus');
                icon.classList.add('fa-plus');
            }
        });
    }
});
</script>