<?php
// FILE NÀY: banhang/mobile_views/suppliers.php

/*
----------------------------------------------------------------------
--- PHẦN LOGIC PHP LẤY DANH SÁCH NHÀ CUNG CẤP ---
----------------------------------------------------------------------
(Bạn chép code logic vào đây)

Giả lập dữ liệu:
*/
if (!isset($danh_sach_ncc)) {
     $danh_sach_ncc = [
        ['ten_ncc' => 'Cửa Hàng A', 'dien_thoai' => '0939920368', 'dia_chi' => '123 Đồng Khởi', 'tong_mua' => 12250000, 'tong_no' => 2500000],
        ['ten_ncc' => 'Huân B', 'dien_thoai' => '0909121286', 'dia_chi' => '456 Nguyễn Thị Minh Khai', 'tong_mua' => 5300000, 'tong_no' => 0],
    ];
}

?>

<a href="#" class="fab">
    <i class="fa-solid fa-plus"></i>
</a>

<div class="filter-bar">
    <div class="search-box">
        <i class="fa-solid fa-search"></i>
        <input type="text" placeholder="Tìm tên, SĐT nhà cung cấp...">
    </div>
    <button class="btn-filter">
        <i class="fa-solid fa-filter"></i>
    </button>
</div>

<div class="list-container">
    <?php foreach ($danh_sach_ncc as $ncc): ?>
    <div class="list-card">
        <div class="list-card-header">
            <i class="fa-solid fa-store customer-avatar"></i>
            <div class="list-card-title">
                <span><?php echo htmlspecialchars($ncc['ten_ncc']); ?></span>
                <span class="sub-text"><?php echo htmlspecialchars($ncc['dien_thoai']); ?></span>
            </div>
            <div class="list-card-actions">
                <a href="#"><i class="fa-solid fa-edit icon-edit"></i></a>
                <a href="#"><i class="fa-solid fa-trash icon-delete"></i></a>
            </div>
        </div>
        <div class="list-card-body">
            <div class="list-stat-item">
                <span class="label">Tổng nhập</span>
                <span class="value"><?php echo number_format($ncc['tong_mua'], 0, ',', '.'); ?> đ</span>
            </div>
            <div class="list-stat-item">
                <span class="label">Nợ NCC</span>
                <span class="value <?php echo ($ncc['tong_no'] > 0) ? 'danger' : ''; ?>"><?php echo number_format($ncc['tong_no'], 0, ',', '.'); ?> đ</span>
            </div>
            <div class="list-stat-item">
                <span class="label">Địa chỉ</span>
                <span class="value"><?php echo htmlspecialchars($ncc['dia_chi']); ?></span>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>