<?php
// FILE NÀY: banhang/mobile_views/customers.php

// (MỚI) Kiểm tra xem có ở chế độ chọn không
$is_selection_mode = isset($_GET['select']) && $_GET['select'] === 'true';

/*
----------------------------------------------------------------------
--- PHẦN LOGIC PHP LẤY DANH SÁCH KHÁCH HÀNG ---
----------------------------------------------------------------------
*/
if (!isset($danh_sach_khach_hang)) {
     $danh_sach_khach_hang = [
        ['ID' => 1, 'customer_name' => 'Khách lẻ', 'customer_phone' => '', 'customer_addr' => '', 'total_mua' => 0, 'total_no' => 0, 'customer_group' => 1],
        ['ID' => 2, 'customer_name' => 'Thu Thảo (xe BM L đường )', 'customer_phone' => '0905123456', 'customer_addr' => '123 Hải Châu, Đà Nẵng', 'total_mua' => 2250000, 'total_no' => 0, 'customer_group' => 1],
        ['ID' => 3, 'customer_name' => 'Thanh Hiền (Khách sỉ)', 'customer_phone' => '0369789456', 'customer_addr' => '456 Liên Chiểu, Đà Nẵng', 'total_mua' => 300000, 'total_no' => 0, 'customer_group' => 0],
        ['ID' => 4, 'customer_name' => 'Anh Bình ( xe IM đen )', 'customer_phone' => '0912654789', 'customer_addr' => '789 Ngũ Hành Sơn, Đà Nẵng', 'total_mua' => 1250000, 'total_no' => 440000, 'customer_group' => 1],
    ];
    // (Bạn dán logic PHP lấy $danh_sach_khach_hang thật vào đây)
}

?>

<?php if (!$is_selection_mode): ?>
    <a href="#" class="fab">
        <i class="fa-solid fa-plus"></i>
    </a>
<?php endif; ?>

<div class="filter-bar">
    <div class="search-box">
        <i class="fa-solid fa-search"></i>
        <input type="text" placeholder="Tìm tên, SĐT khách hàng...">
    </div>
    <button class="btn-filter">
        <i class="fa-solid fa-filter"></i>
    </button>
</div>

<div class="list-container">
    <?php foreach ($danh_sach_khach_hang as $kh): ?>
        <?php
            $customer_json_data = htmlspecialchars(json_encode([
                'id' => $kh['ID'],
                'name' => $kh['customer_name'],
                'group' => $kh['customer_group'] ?? 1 // 1 = Lẻ, 0 = Sỉ
            ]), ENT_QUOTES, 'UTF-8');
        ?>
        <div class="list-card">
            <div class="list-card-header">
                <i class="fa-solid fa-user-circle customer-avatar"></i>
                <div class="list-card-title">
                    <span><?php echo htmlspecialchars($kh['customer_name']); ?></span>
                    <span class="sub-text"><?php echo htmlspecialchars($kh['customer_phone']); ?></span>
                </div>
                
                <?php if ($is_selection_mode): ?>
                    <button class="btn-select-customer" data-customer-json="<?php echo $customer_json_data; ?>">
                        Chọn
                    </button>
                <?php endif; ?>
            </div>
            <div class="list-card-body">
                <div class="list-stat-item">
                    <span class="label">Tổng mua</span>
                    <span class="value"><?php echo number_format($kh['total_mua'], 0, ',', '.'); ?> đ</span>
                </div>
                <div class="list-stat-item">
                    <span class="label">Còn nợ</span>
                    <span class="value <?php echo ($kh['total_no'] > 0) ? 'danger' : ''; ?>"><?php echo number_format($kh['total_no'], 0, ',', '.'); ?> đ</span>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php if ($is_selection_mode): ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.btn-select-customer').forEach(button => {
            button.addEventListener('click', function() {
                const customerData = JSON.parse(this.dataset.customerJson);
                // Lưu khách hàng đã chọn vào localStorage
                localStorage.setItem('pos_customer', JSON.stringify(customerData));
                // Quay lại trang POS
                window.location.href = 'pos_mobile.php';
            });
        });
    });
</script>
<?php endif; ?>