$(document).ready(function() {
    const AJAX_URL = 'ajax/zns_handler.php';
    let templatesData = []; // Lưu trữ dữ liệu các mẫu

    const $templateSelect = $('#zns-template-select');
    const $paramsContainer = $('#zns-parameters-container');
    const $previewContent = $('#zns-preview-content');

    // Khởi tạo Select2
    $templateSelect.select2({
        theme: 'bootstrap-5',
        placeholder: 'Tìm và chọn một mẫu ZNS...',
        allowClear: true
    });

    // 1. Tải danh sách các mẫu ZNS khi trang được tải
    function loadTemplates() {
        $.ajax({
            url: AJAX_URL,
            type: 'GET',
            dataType: 'json',
            data: { action: 'get_templates' },
            success: function(response) {
                if (response.status === 'success') {
                    templatesData = response.data;
                    $templateSelect.empty().append(new Option('', '', true, true));
                    templatesData.forEach(template => {
                        const option = new Option(template.template_name, template.id, false, false);
                        $(option).data('params', template.parameters);
                        $(option).data('template-id-zalo', template.template_id);
                        $templateSelect.append(option);
                    });
                    $templateSelect.trigger('change');
                }
            }
        });
    }

    // 2. Xử lý khi người dùng chọn một mẫu
    $templateSelect.on('change', function() {
        const selectedOption = $(this).find('option:selected');
        const paramsJson = selectedOption.data('params');
        $paramsContainer.empty();

        if (!paramsJson) {
            $paramsContainer.html('<p class="text-muted text-center">Vui lòng chọn một mẫu để hiển thị tham số.</p>');
            return;
        }

        try {
            const params = JSON.parse(paramsJson);
            if (params.length === 0) {
                 $paramsContainer.html('<p class="text-center">Mẫu này không có tham số nào.</p>');
            } else {
                params.forEach(param => {
                    const inputGroup = `
                        <div class="input-group">
                            <span class="input-group-text" style="min-width: 120px;">${param}</span>
                            <input type="text" class="form-control zns-param-input" data-param-name="${param}" placeholder="Nhập giá trị cho ${param}...">
                        </div>
                    `;
                    $paramsContainer.append(inputGroup);
                });
            }
        } catch (e) {
            console.error("Invalid JSON for parameters:", paramsJson);
            $paramsContainer.html('<p class="text-danger text-center">Lỗi cấu trúc tham số.</p>');
        }
    });

    // 3. Cập nhật xem trước (hiện tại là giả lập)
    // Để có bản xem trước chính xác, bạn cần nội dung gốc của template.
    // Tạm thời, chúng ta chỉ hiển thị các giá trị được nhập.
    $(document).on('keyup', '.zns-param-input', function() {
        let previewText = "Xem trước:\n";
        $('.zns-param-input').each(function() {
            const paramName = $(this).data('param-name');
            const paramValue = $(this).val();
            previewText += `${paramName}: ${paramValue}\n`;
        });
        $previewContent.text(previewText);
    });

    // 4. Xử lý khi submit form để gửi chiến dịch
    $('#send-zns-form').on('submit', function(e) {
        e.preventDefault();
        const button = $('#btn-send');
        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Đang gửi...');

        const params = {};
        $('.zns-param-input').each(function() {
            params[$(this).data('param-name')] = $(this).val();
        });

        const selectedOption = $templateSelect.find('option:selected');

        const formData = {
            action: 'send_campaign',
            campaign_name: $('#campaign_name').val(),
            zns_template_db_id: $templateSelect.val(),
            template_id: selectedOption.data('template-id-zalo'),
            params: params,
            // TODO: Thêm dữ liệu người nhận vào đây
        };

        $.ajax({
            url: AJAX_URL,
            type: 'POST',
            dataType: 'json',
            data: formData,
            success: function(response) {
                alert(response.message);
                if(response.status === 'success') {
                    // Reset form
                }
            },
            error: function() {
                alert('Đã có lỗi xảy ra. Vui lòng thử lại.');
            },
            complete: function() {
                 button.prop('disabled', false).html('<i class="fas fa-rocket me-2"></i>Bắt đầu gửi chiến dịch ZNS');
            }
        });
    });

    // Khởi chạy
    loadTemplates();
});