<?php
require_once __DIR__ . '/../core/init.php';
header('Content-Type: application/json');
session_start();

$response = ['status' => 'error', 'message' => 'Có lỗi không xác định.'];

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $response['message'] = 'Yêu cầu không hợp lệ.';
    echo json_encode($response);
    exit();
}

// Lấy dữ liệu từ POST
$customerId = (int)($_POST['customer_id'] ?? 0);
$cartItemsJSON = $_POST['cart_items'] ?? '[]';
$cartItems = json_decode($cartItemsJSON, true);

// Kiểm tra dữ liệu đầu vào
if ($customerId === 0 || empty($cartItems) || !is_array($cartItems)) {
    $response['message'] = 'Dữ liệu đơn hàng không hợp lệ.';
    echo json_encode($response);
    exit();
}

// Bắt đầu transaction để đảm bảo toàn vẹn dữ liệu
$conn->begin_transaction();

try {
    $totalMoney = 0;
    $totalOriginPrice = 0;

    // Lặp qua sản phẩm để kiểm tra và tính toán trên server
    foreach ($cartItems as $item) {
        $productId = (int)$item['id'];
        $quantity = (int)$item['quantity'];

        // Lấy thông tin mới nhất của sản phẩm từ CSDL để xác thực
        $stmt_check = $conn->prepare("SELECT prd_sls, prd_sell_price, prd_origin_price FROM cms_products WHERE id = ? FOR UPDATE");
        $stmt_check->bind_param('i', $productId);
        $stmt_check->execute();
        $product = $stmt_check->get_result()->fetch_assoc();
        $stmt_check->close();

        // VALIDATION SERVER-SIDE
        if (!$product) {
            throw new Exception("Sản phẩm với ID {$productId} không tồn tại.");
        }
        if ($quantity > $product['prd_sls']) {
            throw new Exception("Sản phẩm '{$item['name']}' không đủ tồn kho.");
        }
        if ($product['prd_sell_price'] < $product['prd_origin_price']) {
             throw new Exception("Sản phẩm '{$item['name']}' đang bị bán dưới giá vốn.");
        }
        
        $totalMoney += $product['prd_sell_price'] * $quantity;
        $totalOriginPrice += $product['prd_origin_price'] * $quantity;
    }
    
    // Tạo mã đơn hàng
    $orderCode = 'HD' . time();
    $userId = $_SESSION['user_id'] ?? 0;
    $storeId = $_SESSION['store_id'] ?? 0;

    // 1. INSERT vào bảng cms_orders
    $sql_order = "INSERT INTO cms_orders (output_code, customer_id, sell_date, total_money, total_origin_price, user_init, store_id, detail_order, order_status) VALUES (?, ?, NOW(), ?, ?, ?, ?, ?, 1)";
    $stmt_order = $conn->prepare($sql_order);
    $stmt_order->bind_param('siddiss', $orderCode, $customerId, $totalMoney, $totalOriginPrice, $userId, $storeId, $cartItemsJSON);
    $stmt_order->execute();
    $orderId = $stmt_order->insert_id;
    $stmt_order->close();

    if($orderId == 0) {
        throw new Exception("Không thể tạo đơn hàng chính.");
    }

    // 2. CẬP NHẬT tồn kho
    foreach ($cartItems as $item) {
        $productId = (int)$item['id'];
        $quantity = (int)$item['quantity'];
        
        $sql_update_stock = "UPDATE cms_products SET prd_sls = prd_sls - ? WHERE id = ?";
        $stmt_update = $conn->prepare($sql_update_stock);
        $stmt_update->bind_param('ii', $quantity, $productId);
        $stmt_update->execute();
        $stmt_update->close();
    }
    
    // Nếu mọi thứ thành công, commit transaction
    $conn->commit();
    $response = ['status' => 'success', 'message' => 'Tạo đơn hàng thành công!', 'order_code' => $orderCode];

} catch (Exception $e) {
    // Nếu có lỗi, rollback lại tất cả thay đổi
    $conn->rollback();
    $response['message'] = $e->getMessage();
}

$conn->close();
echo json_encode($response);
?>