<?php
// File: /pages/consolidate_orders/ajax_handler.php
require_once __DIR__ . '/../../core/init.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['action'])) {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Yêu cầu không hợp lệ.']);
    exit;
}

$action = $_POST['action'];

// === LẤY DANH SÁCH ĐƠN HÀNG ĐỂ XEM TRƯỚC ===
if ($action == 'get_orders_for_consolidation') {
    $user_id = (int)$_POST['user_id'];
    $order_date_original = $_POST['order_date_original'];

    $stmt = $conn->prepare("
        SELECT o.output_code, o.total_money, o.consolidated_code, c.customer_name
        FROM cms_orders AS o
        LEFT JOIN cms_customers AS c ON o.customer_id = c.id
        WHERE o.user_init = ? AND DATE(o.sell_date) = ?
        ORDER BY o.id ASC
    ");
    if ($stmt === false) {
        die('<div class="alert alert-danger mt-4">Lỗi truy vấn SQL: ' . htmlspecialchars($conn->error) . '</div>');
    }

    $stmt->bind_param("is", $user_id, $order_date_original);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $unprocessed_count = 0;
    $processed_codes = []; // Mảng để thu thập các mã phiếu đã gộp

    if ($result->num_rows > 0) {
        // Hiển thị bảng danh sách đơn hàng (giữ nguyên logic)
        echo '<div class="card shadow mb-4 mt-4">';
        echo '  <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-success">Danh sách đơn hàng tìm thấy (' . $result->num_rows . ' đơn)</h6></div>';
        echo '  <div class="card-body"><div class="table-responsive"><table class="table table-bordered table-hover">';
        echo '<thead><tr><th>STT</th><th>Mã Đơn Hàng</th><th>Khách Hàng</th><th class="text-right">Tổng Tiền</th><th class="text-center">Trạng thái</th></tr></thead><tbody>';
        $stt = 1;
        while ($row = $result->fetch_assoc()) {
            $is_processed = !empty($row['consolidated_code']);
            if ($is_processed) {
                // Nếu đơn hàng đã được xử lý, thêm mã code vào mảng
                $processed_codes[] = $row['consolidated_code'];
            } else {
                $unprocessed_count++;
            }
            $row_class = $is_processed ? 'processed-row' : '';
            echo '<tr class="' . $row_class . '"><td>' . $stt++ . '</td><td>' . htmlspecialchars($row['output_code']) . '</td><td>' . htmlspecialchars($row['customer_name']) . '</td><td class="text-right">' . number_format($row['total_money']) . '</td>';
            if ($is_processed) { echo '<td class="text-center"><span class="badge badge-secondary">Đã xử lý</span></td>'; } 
            else { echo '<td class="text-center"><span class="badge badge-success">Sẵn sàng</span></td>'; }
            echo '</tr>';
        }
        echo '</tbody></table></div></div></div>';
        
        // ***** BẮT ĐẦU PHẦN CODE MỚI: HIỂN THỊ NÚT IN LẠI *****
        $unique_codes = array_unique($processed_codes); // Lấy các mã phiếu duy nhất

        if (!empty($unique_codes)) {
            echo '<div class="card shadow mb-4">';
            echo '  <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-info"><i class="fas fa-history mr-1"></i>In lại các phiếu đã gộp</h6></div>';
            echo '  <div class="card-body">';
            echo '      <p>Các đơn hàng trong ngày này đã được gộp vào các phiếu sau. Nhấn để in lại:</p>';
            foreach ($unique_codes as $code) {
                $print_url = 'print_consolidated.php?code=' . htmlspecialchars($code);
                echo '<a href="' . $print_url . '" target="_blank" class="btn btn-outline-primary mb-2 mr-2">';
                echo '  <i class="fas fa-print mr-1"></i> In lại phiếu ' . htmlspecialchars($code);
                echo '</a>';
            }
            echo '  </div>';
            echo '</div>';
        }
        // ***** KẾT THÚC PHẦN CODE MỚI *****


        // Hiển thị Bước 2 nếu có đơn hàng chưa xử lý
        if ($unprocessed_count > 0) {
            echo '<div class="card shadow mb-4">';
            echo '  <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Bước 2: Cập nhật và tạo phiếu in cho ' . $unprocessed_count . ' đơn hàng Sẵn sàng</h6></div>';
            echo '  <div class="card-body"><div class="row">';
            echo '      <div class="col-md-6"><label for="new_delivery_date">Chọn ngày giao hàng mới:</label><input type="date" id="new_delivery_date" class="form-control" value="' . date('Y-m-d') . '"></div>';
            echo '      <div class="col-md-6 d-flex align-items-end"><button type="button" id="processBtn" data-user-id="' . htmlspecialchars($user_id) . '" data-original-date="' . htmlspecialchars($order_date_original) . '" class="btn btn-success btn-block"><i class="fas fa-check-circle mr-1"></i> Cập nhật và In phiếu</button></div>';
            echo '  </div></div></div>';
        }

    } else {
        echo '<div class="alert alert-warning mt-4">Không tìm thấy đơn hàng nào cho nhân viên và ngày đã chọn.</div>';
    }
    $stmt->close();
    exit;
}

// === CẬP NHẬT VÀ GỘP ĐƠN HÀNG ===
if ($action == 'update_and_consolidate') {
    header('Content-Type: application/json');
    $errors = [];
    if (!isset($_POST['user_id']) || $_POST['user_id'] === '') { $errors[] = 'ID nhân viên bị thiếu.'; }
    if (empty($_POST['order_date_original'])) { $errors[] = 'Ngày bán hàng gốc bị thiếu.'; }
    if (empty($_POST['new_order_date'])) { $errors[] = 'Ngày giao hàng mới bị thiếu.'; }
    if (!empty($errors)) {
        echo json_encode(['status' => 'error', 'message' => 'Dữ liệu không hợp lệ. Lỗi: ' . implode('; ', $errors)]);
        exit;
    }
    
    $order_date_original = $_POST['order_date_original'];
    $user_id = (int)$_POST['user_id'];
    $new_order_date = $_POST['new_order_date'];
    $new_order_datetime = $new_order_date . ' ' . date('H:i:s'); 
    $consolidated_code = 'PHTH-' . date('YmdHis') . '-' . $user_id;
    
    $conn->begin_transaction();
    try {
        // THAY ĐỔI 2: Cập nhật cột `sell_date` thay vì `created`
        $sql_update = "UPDATE cms_orders SET `sell_date` = ?, `consolidated_code` = ? WHERE `user_init` = ? AND DATE(`sell_date`) = ? AND `consolidated_code` IS NULL";
        $stmt_update = $conn->prepare($sql_update);
        if ($stmt_update === false) { throw new Exception("Lỗi khi chuẩn bị câu lệnh: " . $conn->error); }
        $stmt_update->bind_param('ssis', $new_order_datetime, $consolidated_code, $user_id, $order_date_original);
        $stmt_update->execute();
        $affected_rows = $stmt_update->affected_rows;
        if ($affected_rows == 0) { throw new Exception("Không có đơn hàng nào được cập nhật."); }
        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => "Đã cập nhật thành công {$affected_rows} đơn hàng.", 'consolidated_code' => $consolidated_code]);
    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(['status' => 'error', 'message' => 'Lỗi xử lý: ' . $e->getMessage()]);
    }
    exit;
}